<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
        }
        .header {
            background-color: #337ab7;
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logo a {
            color: white;
            text-decoration: none;
            font-size: 1.5rem;
            font-weight: bold;
        }
        .nav-menu ul {
            list-style: none;
            display: flex;
            gap: 20px;
        }
        .nav-menu a {
            color: white;
            text-decoration: none;
            padding: 5px 10px;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        .nav-menu a:hover {
            background-color: rgba(255,255,255,0.2);
        }
        .dropdown {
            position: relative;
        }
        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: white;
            min-width: 200px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
            border-radius: 4px;
            z-index: 1000;
        }
        .dropdown:hover .dropdown-content {
            display: block;
        }
        .dropdown-content a {
            color: #333;
            padding: 12px 16px;
            display: block;
        }
        .dropdown-content a:hover {
            background-color: #f4f4f4;
        }
        .dropdown-header {
            padding: 12px 16px;
            color: #666;
            font-size: 0.9rem;
            border-bottom: 1px solid #ddd;
        }
        .divider {
            height: 1px;
            background-color: #ddd;
            margin: 8px 0;
        }
        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 0 20px;
        }
        .content {
            background-color: white;
            padding: 20px;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            min-height: 400px;
        }
        .footer {
            background-color: #fff;
            padding: 20px 0;
            margin-top: 40px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
        }
        .breadcrumbs {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f8f8f8;
            border-radius: 4px;
        }
        .breadcrumbs a {
            color: #337ab7;
            text-decoration: none;
        }
        .breadcrumbs a:hover {
            text-decoration: underline;
        }
        .flash-messages {
            margin-bottom: 20px;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border: 1px solid transparent;
            border-radius: 4px;
        }
        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border-color: #c3e6cb;
        }
        .alert-danger {
            color: #721c24;
            background-color: #f8d7da;
            border-color: #f5c6cb;
        }
        .alert-info {
            color: #0c5460;
            background-color: #d1ecf1;
            border-color: #bee5eb;
        }
    </style>
</head>
<body>
<?php $this->beginBody() ?>

<div class="header">
    <div class="header-content">
        <div class="logo">
            <a href="<?= Url::to(['/site/index']) ?>"><?= Html::encode(Yii::$app->name) ?></a>
        </div>
        <div class="nav-menu">
            <ul>
                <li><a href="<?= Url::to(['/site/index']) ?>">Главная</a></li>
                <li><a href="<?= Url::to(['/site/about']) ?>">О проекте</a></li>
                <li><a href="<?= Url::to(['/site/contact']) ?>">Контакты</a></li>
                <?php if (Yii::$app->user->isGuest): ?>
    <li><a href="<?= Url::to(['/site/login']) ?>">Вход</a></li>
    <li><a href="<?= Url::to(['/site/signup']) ?>">Регистрация</a></li>
<?php else: ?>
                    <li class="dropdown">
                        <a href="#">Мой профиль (<?= Html::encode(Yii::$app->user->identity->username) ?>) ▼</a>
                        <div class="dropdown-content">
                            <div class="dropdown-header">Настройки безопасности</div>
                            <a href="<?= Url::to(['/profile/index']) ?>">Настройки 2FA</a>
                            <div class="divider"></div>
                            <div class="dropdown-header">Аккаунт</div>
                            <a href="<?= Url::to(['/site/logout']) ?>" data-method="post">Выход</a>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>

<div class="container">
    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="flash-messages">
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (Yii::$app->session->hasFlash('error')): ?>
        <div class="flash-messages">
            <div class="alert alert-danger">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (Yii::$app->session->hasFlash('info')): ?>
        <div class="flash-messages">
            <div class="alert alert-info">
                <?= Yii::$app->session->getFlash('info') ?>
            </div>
        </div>
    <?php endif; ?>

    <?= Breadcrumbs::widget([
        'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        'options' => ['class' => 'breadcrumbs'],
        'itemTemplate' => "{link} / ",
        'activeItemTemplate' => "{link}",
    ]) ?>

    <div class="content">
        <?= $content ?>
    </div>
</div>

<div class="footer">
    <div class="container">
        <p>&copy; <?= Html::encode(Yii::$app->name) ?> <?= date('Y') ?>. Все права защищены.</p>
    </div>
</div>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>