<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Настройка двухфакторной аутентификации';
$this->params['breadcrumbs'][] = $this->title;
?>

<style>
    .profile-2fa {
        max-width: 1200px;
        margin: 0 auto;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -15px;
    }
    .col-md-6 {
        flex: 0 0 50%;
        max-width: 50%;
        padding: 0 15px;
        box-sizing: border-box;
    }
    .panel {
        margin-bottom: 20px;
        background-color: #fff;
        border: 1px solid #ddd;
        border-radius: 4px;
        box-shadow: 0 1px 1px rgba(0,0,0,.05);
    }
    .panel-heading {
        padding: 10px 15px;
        border-bottom: 1px solid #ddd;
        border-top-left-radius: 3px;
        border-top-right-radius: 3px;
        background-color: #f5f5f5;
    }
    .panel-title {
        margin: 0;
        font-size: 16px;
        font-weight: 500;
    }
    .panel-body {
        padding: 15px;
    }
    .text-center {
        text-align: center;
    }
    .text-muted {
        color: #6c757d;
    }
    .img-responsive {
        max-width: 100%;
        height: auto;
        display: block;
        margin: 0 auto;
    }
    .form-group {
        margin-bottom: 15px;
    }
    .form-control {
        display: block;
        width: 100%;
        padding: 8px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        background-image: none;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .btn {
        display: inline-block;
        padding: 8px 16px;
        margin-bottom: 0;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857143;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        cursor: pointer;
        border: 1px solid transparent;
        border-radius: 4px;
        text-decoration: none;
    }
    .btn-success {
        color: #fff;
        background-color: #5cb85c;
        border-color: #4cae4c;
    }
    .btn-success:hover {
        background-color: #449d44;
        border-color: #398439;
    }
    .btn-danger {
        color: #fff;
        background-color: #d9534f;
        border-color: #d43f3a;
    }
    .btn-danger:hover {
        background-color: #c9302c;
        border-color: #ac2925;
    }
    .btn-primary {
        color: #fff;
        background-color: #337ab7;
        border-color: #2e6da4;
    }
    .btn-primary:hover {
        background-color: #286090;
        border-color: #204d74;
    }
    .alert {
        padding: 15px;
        margin-bottom: 20px;
        border: 1px solid transparent;
        border-radius: 4px;
    }
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
    }
    .alert-success h4 {
        margin-top: 0;
        color: inherit;
    }
    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
    }
    .alert-warning {
        color: #856404;
        background-color: #fff3cd;
        border-color: #ffeeba;
    }
    ul {
        padding-left: 20px;
    }
    strong {
        font-weight: 700;
    }
    .test-codes {
        margin-top: 15px;
        padding: 10px;
        background-color: #f8f9fa;
        border: 1px dashed #6c757d;
        border-radius: 4px;
    }
    .test-code-item {
        display: inline-block;
        padding: 5px 10px;
        margin: 5px;
        background-color: #e9ecef;
        border-radius: 4px;
        font-family: monospace;
        font-size: 18px;
        font-weight: bold;
    }
</style>

<div class="profile-2fa">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if ($user->otp_enabled): ?>
        <div class="alert alert-success">
            <h4>✓ 2FA включена</h4>
            <p>Двухфакторная аутентификация активна для вашей учетной записи.</p>
            <?= Html::a('Отключить 2FA', ['disable'], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Вы уверены, что хотите отключить двухфакторную аутентификацию?',
                    'method' => 'post',
                ],
            ]) ?>
        </div>
    <?php else: ?>
      

        <div class="row">
            <div class="col-md-6">
                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Шаг 1: Установите приложение аутентификатор (для реального использования)</h3>
                    </div>
                    <div class="panel-body">
                        <p>Установите Google Authenticator или аналогичное приложение на ваш смартфон:</p>
                        <ul>
                            <li>Google Authenticator (Android/iOS)</li>
                            <li>Authy (Android/iOS)</li>
                            <li>Microsoft Authenticator (Android/iOS)</li>
                        </ul>
                    </div>
                </div>

                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Шаг 2: Отсканируйте QR-код</h3>
                    </div>
                    <div class="panel-body text-center">
                        <?php if ($qrCodeUrl): ?>
                            <img src="<?= Yii::getAlias('@web/img/qr.png') ?>" alt="QR Code">
                            <p class="text-muted">Или введите ключ вручную: <strong><?= $secret ?></strong></p>
                            
                          
                            <div class="test-codes">
                                <p> Текущий действительный код (если нет приложения):</p>
                                <span class="test-code-item"><?= $currentCode ?></span>
                                <p class="text-muted" style="margin-top: 10px; font-size: 12px;">* Этот код меняется каждые 30 секунд</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel">
                    <div class="panel-heading">
                        <h3 class="panel-title">Шаг 3: Подтвердите настройку</h3>
                    </div>
                    <div class="panel-body">
                        <p>Введите 6-значный код для подтверждения:</p>
                        
                        <?php $form = ActiveForm::begin(['id' => 'otp-form']); ?>
                        
                        <div class="form-group">
                            <?= $form->field($model, 'otp_code')->textInput([
                                'class' => 'form-control',
                                'autocomplete' => 'off',
                                'placeholder' => 'Введите 6-значный код',
                                'maxlength' => 6
                            ])->label('Код подтверждения') ?>
                        </div>
                        
                        <div class="form-group">
                            <?= Html::submitButton('Подтвердить и включить 2FA', ['class' => 'btn btn-success']) ?>
                        </div>

                        <div class="alert alert-info" style="margin-top: 20px;">
                            <strong>📱 Тестовые коды:</strong>
                            <ul style="margin-top: 10px;">
                                <li><strong>123456</strong> - всегда работает</li>
                                <li><strong>000000</strong> - всегда работает</li>
                                <li><strong><?= $currentCode ?></strong> - текущий код (меняется каждые 30 сек)</li>
                            </ul>
                        </div>
                        
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>