<?php
use yii\helpers\Html;

$this->title = 'Главная';
?>

<style>
    .site-index {
        text-align: center;
    }
    .jumbotron {
        background-color: #f8f9fa;
        padding: 40px;
        border-radius: 8px;
        margin-bottom: 30px;
    }
    .jumbotron h1 {
        font-size: 48px;
        margin-bottom: 20px;
        color: #337ab7;
    }
    .jumbotron p {
        font-size: 18px;
        color: #666;
        margin-bottom: 30px;
    }
    .btn-container {
        display: flex;
        gap: 20px;
        justify-content: center;
        margin-top: 30px;
    }
    .btn {
        display: inline-block;
        padding: 12px 24px;
        font-size: 16px;
        font-weight: 400;
        line-height: 1.42857143;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        cursor: pointer;
        border: 1px solid transparent;
        border-radius: 4px;
        text-decoration: none;
        transition: background-color 0.3s;
    }
    .btn-primary {
        color: #fff;
        background-color: #337ab7;
        border-color: #2e6da4;
    }
    .btn-primary:hover {
        background-color: #286090;
        border-color: #204d74;
    }
    .btn-success {
        color: #fff;
        background-color: #5cb85c;
        border-color: #4cae4c;
    }
    .btn-success:hover {
        background-color: #449d44;
        border-color: #398439;
    }
    .features {
        display: flex;
        gap: 30px;
        justify-content: center;
        margin-top: 50px;
    }
    .feature-item {
        flex: 1;
        max-width: 300px;
        padding: 20px;
        background-color: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .feature-item h3 {
        color: #337ab7;
        margin-bottom: 15px;
    }
    .feature-item p {
        color: #666;
        line-height: 1.6;
    }
</style>

<div class="site-index">
    <div class="jumbotron">
        <h1>Добро пожаловать!</h1>
        <p>Это демонстрационное приложение с двухфакторной аутентификацией (2FA) на базе Yii2.</p>
        
        <?php if (Yii::$app->user->isGuest): ?>
            <div class="btn-container">
                <?= Html::a('Войти', ['/site/login'], ['class' => 'btn btn-primary']) ?>
                <?= Html::a('Зарегистрироваться', ['/site/signup'], ['class' => 'btn btn-success']) ?>
            </div>
        <?php else: ?>
            <div class="btn-container">
                <?= Html::a('Настроить 2FA', ['/profile/index'], ['class' => 'btn btn-primary']) ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="features">
        <div class="feature-item">
            <h3>Безопасность</h3>
            <p>Двухфакторная аутентификация с использованием TOTP (Time-based One-time Password) для максимальной защиты вашего аккаунта.</p>
        </div>
        <div class="feature-item">
            <h3>Простота</h3>
            <p>Легкая настройка через QR-код. Поддержка всех популярных приложений-аутентификаторов: Google Authenticator, Authy, Microsoft Authenticator и других.</p>
        </div>
        <div class="feature-item">
            <h3>Надежность</h3>
            <p>Даже если ваш пароль будет скомпрометирован, злоумышленники не смогут войти в аккаунт без одноразового кода из вашего телефона.</p>
        </div>
    </div>
</div>