<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Вход';
$this->params['breadcrumbs'][] = $this->title;
?>

<style>
    .site-login {
        max-width: 500px;
        margin: 0 auto;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -15px;
    }
    .col-lg-5 {
        flex: 0 0 41.666667%;
        max-width: 41.666667%;
        padding: 0 15px;
        box-sizing: border-box;
    }
    .form-group {
        margin-bottom: 15px;
    }
    .form-control {
        display: block;
        width: 100%;
        padding: 8px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .checkbox {
        margin: 15px 0;
    }
    .checkbox label {
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
    }
    .btn {
        display: inline-block;
        padding: 8px 16px;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857143;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        cursor: pointer;
        border: 1px solid transparent;
        border-radius: 4px;
        text-decoration: none;
        color: #fff;
        background-color: #337ab7;
        border-color: #2e6da4;
    }
    .btn:hover {
        background-color: #286090;
        border-color: #204d74;
    }
    .alert {
        padding: 15px;
        margin-top: 20px;
        border: 1px solid transparent;
        border-radius: 4px;
    }
    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
    }
    .help-block {
        color: #a94442;
        font-size: 12px;
        margin-top: 5px;
    }
    .signup-link {
        margin-top: 20px;
        text-align: center;
    }
    .signup-link a {
        color: #337ab7;
        text-decoration: none;
    }
    .signup-link a:hover {
        text-decoration: underline;
    }
</style>

<div class="site-login">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Заполните следующие поля для входа:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>

            <div class="form-group">
                <?= $form->field($model, 'username')->textInput([
                    'class' => 'form-control',
                    'autofocus' => true,
                    'placeholder' => 'Введите имя пользователя'
                ]) ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'password')->passwordInput([
                    'class' => 'form-control',
                    'placeholder' => 'Введите пароль'
                ]) ?>
            </div>

            <div class="checkbox">
                <?= $form->field($model, 'rememberMe')->checkbox([
                    'template' => "{input} {label}",
                    'class' => 'checkbox'
                ]) ?>
            </div>

            <div class="form-group">
                <?= Html::submitButton('Войти', ['class' => 'btn', 'name' => 'login-button']) ?>
            </div>

            <div class="alert alert-info">
                <strong>ℹ Примечание:</strong> Если у вас включена двухфакторная аутентификация, после ввода логина и пароля вы будете перенаправлены на страницу ввода кода подтверждения.
            </div>

            <div class="signup-link">
                Нет аккаунта? <?= Html::a('Зарегистрироваться', ['/site/signup']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>